% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootglm.R
\name{bootglm}
\alias{bootglm}
\title{Bootstrap for Generalized Linear Model}
\usage{
bootglm(model, data, func, B, ...)
}
\arguments{
\item{model}{An object of class \code{lm} or \code{glm}.}

\item{data}{The dataframe used to fit the model.}

\item{func}{The function to apply to each sample.}

\item{B}{A positive integer; the number of bootstrap replications}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
\code{bootglm} returns an object of class \code{boodd}
(see \link{class.boodd}).
}
\description{
Parametric bootstrap for generalized linear model.
}
\details{
The parametric bootstrap simply consists in resampling data in the
model with estimated parameters. \code{bootglm} uses this principle
for Generalized Linear Models (GLM) conditionally to the explanatory
variables (see Beran (1997)) for the conditions of validity of this method.
}
\examples{
\donttest{
B <- 999
x <- runif(100)
e <- rnorm(100)
y <- x + e>0
data <- data.frame(x,y)
glm_probit <- glm(y ~ x, family=binomial(link="probit"),data=data) 
# Define the function to bootstrap: the mle in the probit model
coeff <- function(data){gg=glm(y ~ x, family=binomial(link="probit"),data=data)$coeff}
boo1 <- bootglm(glm_probit,data,coeff,B) 
# parametric bootstrap of the coeffitients of a probit model
plot(boo1,main=c("Boostrap of GLM : probit model","Coefficient"))

# coeffv : a function to return coeff and variance of coefficients 
coeffv <- function(data){
  gg <- glm(y~ x, family=binomial(link="probit"),data=data) 
  var <- diag(summary(gg)$cov.u)
  c(gg$coeff,var)
} 
# Parametric bootstrap of all coeff and variances
boo2 <- bootglm(glm_probit,data,coeffv,B)
# Construct all type of confidence intervals including bootstrap-t 
# and symmetric bootstrap-t 
confint(boo2,method="all")

# Family Poisson (Poisson regression)
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
data <- data.frame(treatment,outcome,counts)
gl <- glm(counts ~ outcome + treatment,family=poisson())
meancounts <- function(data) {mean(data$counts)}
boo3 <- bootglm(gl,data,meancounts,B)
confint(boo3,method="all")
plot(boo3)
}
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek)- submitted.

Beran, R. (1997). Diagnosing Bootstrap Success, \emph{Annals of
the Institute of Statistical Mathematics}, \bold{49}, 1-24.
}
\seealso{
\code{\link{bootsemi}}.
}
\keyword{"Parametric}
\keyword{Bootstrap"}
\keyword{GLM.}
