% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/14_pricingWithSptSeq.R
\name{pricingWithSptSeq}
\alias{pricingWithSptSeq}
\title{Calculate Present Value or the Price of the Bond using two different Sequences of Spot Rates.}
\usage{
pricingWithSptSeq(cpns, sp, t, mv, n)
}
\arguments{
\item{cpns}{A vector.}

\item{sp}{A vector.}

\item{t}{A vector.}

\item{mv}{A number.}

\item{n}{A number.}
}
\value{
Input values to five arguments  \code{cpns} , \code{sp},\code{t}, \code{mv}, and \code{n}.
}
\description{
Calculate Present Value or the Price of the Bond using two different Sequences of Spot Rates.
}
\details{
The method  \code{pricingWithSptSeq()} is developed to compute the Price of Bond using Sequences of the Spot Rates. So,  \code{pricingWithSptSeq()} gives the Price of Bond using two different series or sequences of Spot Rates for values passed to its five arguments. Here \code{cpns} represents the dollar values of all the coupon payments,\code{sp} is a vector of spot rates, \code{t} is a vector of number of years ranging from 1 to any specified number of years till maturity, \code{mv} is Maturity Value, and \code{n} is number of years till maturity. The output is rounded off to three decimal places. The given examples show various ways in which the arguments can be passed to \code{pricingWithSptSeq()}.
}
\examples{
pricingWithSptSeq (cpns=c(3,3,3,3), sp=c(0.0408,0.0401,0.0370,0.0350), t=c(1,2,3,4),mv=100,n=4)
pricingWithSptSeq (cpns=c(3,3,3,3), sp=c(0.0039,0.0140,0.0250,0.0360), t=c(1,2,3,4),mv=100,n=4)
pricingWithSptSeq (c(3,3,3,3), c(0.0408,0.0401,0.0370,0.0350), c(1,2,3,4),100,4)
pricingWithSptSeq (c(3,3,3,3), c(0.0039,0.0140,0.0250,0.0360), c(1,2,3,4),100,4)
pricingWithSptSeq (cpns=c(3,3,3,3), sp=c(0.0408,0.0401,0.0370,0.0350), t=c(1:4),mv=100,n=4)
pricingWithSptSeq (cpns=c(3,3,3,3), sp=c(0.0039,0.0140,0.0250,0.0360), t=c(1:4),mv=100,n=4)
pricingWithSptSeq (c(3,3,3,3), c(0.0408,0.0401,0.0370,0.0350), c(1:4),100,4)
pricingWithSptSeq (c(3,3,3,3), c(0.0039,0.0140,0.0250,0.0360), c(1:4),100,4)
pricingWithSptSeq (cpns=c(rep(3,4)), sp=c(0.0408,0.0401,0.0370,0.0350), t=c(1:4),mv=100,n=4)
pricingWithSptSeq (cpns=c(rep(3,4)), sp=c(0.0039,0.0140,0.0250,0.0360), t=c(1:4),mv=100,n=4)
pricingWithSptSeq (c(rep(3,4)), c(0.0408,0.0401,0.0370,0.0350), c(1:4),100,4)
pricingWithSptSeq (c(rep(3,4)), c(0.0039,0.0140,0.0250,0.0360), c(1:4),100,4)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
