% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/42_bondPricingUsingGspread.R
\name{pricingWithGspread}
\alias{pricingWithGspread}
\title{Calculates Bond Price using given values of G-Spread and yield-to-maturity for the government benchmark bond.}
\usage{
pricingWithGspread(coupons, t, mv, n, ytmBenchGovtBond, Gspread)
}
\arguments{
\item{coupons}{A vector.}

\item{t}{A vector.}

\item{mv}{A number.}

\item{n}{A number.}

\item{ytmBenchGovtBond}{A number.}

\item{Gspread}{A number.}
}
\value{
Input values to six arguments  \code{coupons} ,\code{t}, \code{mv},\code{n}, \code{ytmBenchGovtBond}, and \code{Gspread}.
}
\description{
Calculates Bond Price using given values of G-Spread and yield-to-maturity for the government benchmark bond.
}
\details{
According to information provided by Adams and Smith (2019),  the method \code{pricingWithGspread} is developed to compute Bond Price using the given values of G-Spread and the yield-to-maturity for the government benchmark bond. Here, \code{coupons} is vector of Coupon Payments,\code{t} is a vector of number of years ranging from 1 to any specified number of years under consideration, \code{mv} is maturity value of the bond, \code{n} is number of years, \code{ytmBenchGovtBond} is the yield-to-maturity for the government benchmark bond, and \code{Gspread} is given value of G-spread.
}
\examples{
pricingWithGspread(coupons=c(6,6), t=c(1,2),mv=100,n=2,ytmBenchGovtBond=0.03605, Gspread=0.02327)
pricingWithGspread(coupons=c(5,5,5),t=c(1,2,3),mv=100,n=3,ytmBenchGovtBond=0.01913,Gspread=0.0285)
pricingWithGspread(coupons=c(60,60),t=c(1,2),mv=1000,n=2,ytmBenchGovtBond=0.03605,Gspread=0.02327)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
