% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d11_changePvFullBondPrice.R
\name{changePvFullBondPrice}
\alias{changePvFullBondPrice}
\title{Calculates estimated change in the Full Price of the Bond (in currency units) for a given Money Duration and a given change in the Yield-To-Maturity.}
\usage{
changePvFullBondPrice(moneyDuration, changeYtm)
}
\arguments{
\item{moneyDuration}{A number.}

\item{changeYtm}{A number.}
}
\value{
Input values to two arguments  \code{moneyDuration} and \code{changeYtm}.
}
\description{
Calculates estimated change in the Full Price of the Bond (in currency units) for a given Money Duration and a given change in the Yield-To-Maturity.
}
\details{
According to information provided by Adams and Smith (2019), the method \code{changePvFullBondPrice()} is developed to compute estimated change in the Full Price of the Bond (in currency units) for a given Money Duration and a given Change in the Yield-To-Maturity.
}
\examples{
changePvFullBondPrice(moneyDuration=542.3638,changeYtm=0.01)
changePvFullBondPrice(moneyDuration=542.3638,changeYtm=-0.01)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Understanding Fixed‑Income Risk and Return. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 237-299). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
