% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_bondPriceExcessCoupon.R
\name{bondPriceExcessCoupon}
\alias{bondPriceExcessCoupon}
\title{Calculates the Price of Bond making Excess Coupon Payments.}
\usage{
bondPriceExcessCoupon(couponExcess, times, r)
}
\arguments{
\item{couponExcess}{A vector.}

\item{times}{A vector.}

\item{r}{A number.}
}
\value{
Input values to three arguments  \code{couponExcess} , \code{times} and \code{r}.
}
\description{
Calculates the Price of Bond making Excess Coupon Payments.
}
\details{
For Example, if the present value of excess is +7.260, discounted using the required yield per period, then the price of the bond is 107.260 (= 100 + 7.260)(Adams & Smith, 2019).
Based on the information presented, the method \code{bondPriceExcessCoupon()} is developed to compute the Price of Bond making excess Coupon Payments. So,  \code{bondPriceExcessCoupon()} gives the Price of Bond making excess Coupon Payments for values passed to its three arguments. Here, \code{couponExcess} represents the dollar value of excess coupon payments, \code{times} is a vector of number of years ranging from 1 to any specified number of years till maturity, and \code{r} is Market Discount Rate or Required Rate of return. The output is rounded off to three decimal places. The given examples show various ways in which the arguments can be passed to \code{bondPriceExcessCoupon()}.
}
\references{
Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
bondPriceExcessCoupon(couponExcess=c(2,2,2,2), times=c(1,2,3,4), r= 0.04)
bondPriceExcessCoupon(couponExcess=c(2,2,2,2), times=c(1:4), r= 0.04)
bondPriceExcessCoupon(couponExcess=c(rep(2,4)), times=c(1:4), r= 0.04)
bondPriceExcessCoupon(c(rep(2,4)), c(1:4), 0.04)
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
