% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.bnns}
\alias{summary.bnns}
\title{Summary of a Bayesian Neural Network (BNN) Model}
\usage{
\method{summary}{bnns}(object, ...)
}
\arguments{
\item{object}{An object of class \code{bnns}, representing a fitted Bayesian Neural Network model.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A list (returned invisibly) containing the following elements:
\itemize{
\item \code{"Number of observations"}: The number of observations in the training data.
\item \code{"Number of features"}: The number of features in the training data.
\item \code{"Number of hidden layers"}: The number of hidden layers in the neural network.
\item \code{"Nodes per layer"}: A comma-separated string representing the number of nodes in each hidden layer.
\item \code{"Activation functions"}: A comma-separated string representing the activation functions used in each hidden layer.
\item \code{"Output activation function"}: The activation function used in the output layer.
\item \code{"Stanfit Summary"}: A summary of the Stan model, including key parameter posterior distributions.
\item \code{"Iterations"}: The total number of iterations used for sampling in the Bayesian model.
\item \code{"Warmup"}: The number of iterations used as warmup in the Bayesian model.
\item \code{"Thinning"}: The thinning interval used in the Bayesian model.
\item \code{"Chains"}: The number of Markov chains used in the Bayesian model.
\item \code{"Performance"}: Predictive performance metrics, which vary based on the output activation function.
}
The function also prints the summary to the console.
}
\description{
Provides a comprehensive summary of a fitted Bayesian Neural Network (BNN) model, including details about the model call, data, network architecture, posterior distributions, and model fitting information.
}
\details{
The function prints the following information:
\itemize{
\item \strong{Call:} The original function call used to fit the model.
\item \strong{Data Summary:} Number of observations and features in the training data.
\item \strong{Network Architecture:} Structure of the BNN including the number of hidden layers, nodes per layer, and activation functions.
\item \strong{Posterior Summary:} Summarized posterior distributions of key parameters (e.g., weights, biases, and noise parameter).
\item \strong{Model Fit Information:} Bayesian sampling details, including the number of iterations, warmup period, thinning, and chains.
\item \strong{Notes:} Remarks and warnings, such as checks for convergence diagnostics.
}
}
\examples{
\donttest{
# Fit a Bayesian Neural Network
data <- data.frame(x1 = runif(10), x2 = runif(10), y = rnorm(10))
model <- bnns(y ~ -1 + x1 + x2,
  data = data, L = 1, nodes = 2, act_fn = 2,
  iter = 1e1, warmup = 5, chains = 1
)

# Get a summary of the model
summary(model)
}
}
\seealso{
\code{\link{bnns}}, \code{\link{print.bnns}}
}
