% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activation_functions.R
\name{softmax_3d}
\alias{softmax_3d}
\title{Apply Softmax Function to a 3D Array}
\usage{
softmax_3d(x)
}
\arguments{
\item{x}{A 3D array. The input array on which the softmax function will be applied.}
}
\value{
A 3D array of the same dimensions as \code{x}, where the values along the
third dimension are transformed using the softmax function.
}
\description{
This function applies the softmax transformation along the third dimension
of a 3D array. The softmax function converts raw scores into probabilities
such that they sum to 1 for each slice along the third dimension.
}
\details{
The softmax transformation is computed as:
\deqn{\text{softmax}(x_{ijk}) = \frac{\exp(x_{ijk})}{\sum_{l} \exp(x_{ijl})}}
This is applied for each pair of indices \verb{(i, j)} across the third dimension \code{(k)}.

The function processes the input array slice-by-slice for the first two dimensions
\verb{(i, j)}, normalizing the values along the third dimension \code{(k)} for each slice.
}
\examples{
# Example: Apply softmax to a 3D array
x <- array(runif(24), dim = c(2, 3, 4)) # Random 3D array (2x3x4)
softmax_result <- softmax_3d(x)

}
