% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnns.R
\name{bnns}
\alias{bnns}
\title{Generic Function for Fitting Bayesian Neural Network Models}
\usage{
bnns(
  formula,
  data,
  L = 1,
  nodes = rep(2, L),
  act_fn = rep(2, L),
  out_act_fn = 1,
  iter = 1000,
  warmup = 200,
  thin = 1,
  chains = 2,
  cores = 2,
  seed = 123,
  prior_weights = NULL,
  prior_bias = NULL,
  prior_sigma = NULL,
  verbose = FALSE,
  refresh = max(iter/10, 1),
  normalize = TRUE,
  ...
)
}
\arguments{
\item{formula}{A symbolic description of the model to be fitted. The formula should specify the response variable and predictors (e.g., \code{y ~ x1 + x2}). \code{y} must be continuous for regression (\code{out_act_fn = 1}), numeric 0/1 for binary classification (\code{out_act_fn = 2}), and factor with at least 3 levels for multi-classification (\code{out_act_fn = 3}).}

\item{data}{A data frame containing the variables in the model.}

\item{L}{An integer specifying the number of hidden layers in the neural network. Default is 1.}

\item{nodes}{An integer or vector specifying the number of nodes in each hidden layer. If a single value is provided, it is applied to all layers. Default is 16.}

\item{act_fn}{An integer or vector specifying the activation function(s) for the hidden layers. Options are:
\itemize{
\item \code{1} for tanh
\item \code{2} for sigmoid (default)
\item \code{3} for softplus
\item \code{4} for ReLU
\item \code{5} for linear
}}

\item{out_act_fn}{An integer specifying the activation function for the output layer. Options are:
\itemize{
\item \code{1} for linear (default)
\item \code{2} for sigmoid
\item \code{3} for softmax
}}

\item{iter}{An integer specifying the total number of iterations for the Stan sampler. Default is \code{1e3}.}

\item{warmup}{An integer specifying the number of warmup iterations for the Stan sampler. Default is \code{2e2}.}

\item{thin}{An integer specifying the thinning interval for Stan samples. Default is 1.}

\item{chains}{An integer specifying the number of Markov chains. Default is 2.}

\item{cores}{An integer specifying the number of CPU cores to use for parallel sampling. Default is 2.}

\item{seed}{An integer specifying the random seed for reproducibility. Default is 123.}

\item{prior_weights}{A list specifying the prior distribution for the weights in the neural network.
The list must include two components:
\itemize{
\item \code{dist}: A character string specifying the distribution type. Supported values are
\code{"normal"}, \code{"uniform"}, and \code{"cauchy"}.
\item \code{params}: A named list specifying the parameters for the chosen distribution:
\itemize{
\item For \code{"normal"}: Provide \code{mean} (mean of the distribution) and \code{sd} (standard deviation).
\item For \code{"uniform"}: Provide \code{alpha} (lower bound) and \code{beta} (upper bound).
\item For \code{"cauchy"}: Provide \code{mu} (location parameter) and \code{sigma} (scale parameter).
}
}
If \code{prior_weights} is \code{NULL}, the default prior is a \code{normal(0, 1)} distribution.
For example:
\itemize{
\item \code{list(dist = "normal", params = list(mean = 0, sd = 1))}
\item \code{list(dist = "uniform", params = list(alpha = -1, beta = 1))}
\item \code{list(dist = "cauchy", params = list(mu = 0, sigma = 2.5))}
}}

\item{prior_bias}{A list specifying the prior distribution for the biases in the neural network.
The list must include two components:
\itemize{
\item \code{dist}: A character string specifying the distribution type. Supported values are
\code{"normal"}, \code{"uniform"}, and \code{"cauchy"}.
\item \code{params}: A named list specifying the parameters for the chosen distribution:
\itemize{
\item For \code{"normal"}: Provide \code{mean} (mean of the distribution) and \code{sd} (standard deviation).
\item For \code{"uniform"}: Provide \code{alpha} (lower bound) and \code{beta} (upper bound).
\item For \code{"cauchy"}: Provide \code{mu} (location parameter) and \code{sigma} (scale parameter).
}
}
If \code{prior_bias} is \code{NULL}, the default prior is a \code{normal(0, 1)} distribution.
For example:
\itemize{
\item \code{list(dist = "normal", params = list(mean = 0, sd = 1))}
\item \code{list(dist = "uniform", params = list(alpha = -1, beta = 1))}
\item \code{list(dist = "cauchy", params = list(mu = 0, sigma = 2.5))}
}}

\item{prior_sigma}{A list specifying the prior distribution for the \code{sigma} parameter in regression
models (\code{out_act_fn = 1}). This allows for setting priors on the standard deviation of the residuals.
The list must include two components:
\itemize{
\item \code{dist}: A character string specifying the distribution type. Supported values are
\code{"half-normal"} and \code{"inverse-gamma"}.
\item \code{params}: A named list specifying the parameters for the chosen distribution:
\itemize{
\item For \code{"half-normal"}: Provide \code{sd} (standard deviation of the half-normal distribution).
\item For \code{"inverse-gamma"}: Provide \code{shape} (shape parameter) and \code{scale} (scale parameter).
}
}
If \code{prior_sigma} is \code{NULL}, the default prior is a \code{half-normal(0, 1)} distribution.
For example:
\itemize{
\item \code{list(dist = "half_normal", params = list(mean = 0, sd = 1))}
\item \code{list(dist = "inv_gamma", params = list(alpha = 1, beta = 1))}
}}

\item{verbose}{TRUE or FALSE: flag indicating whether to print intermediate output from Stan on the console, which might be helpful for model debugging.}

\item{refresh}{refresh (integer) can be used to control how often the progress of the sampling is reported (i.e. show the progress every refresh iterations). By default, refresh = max(iter/10, 1). The progress indicator is turned off if refresh <= 0.}

\item{normalize}{Logical. If \code{TRUE} (default), the input predictors
are normalized to have zero mean and unit variance before training.
Normalization ensures stable and efficient Bayesian sampling by standardizing
the input scale, which is particularly beneficial for neural network training.
If \code{FALSE}, no normalization is applied, and it is assumed that the input data
is already pre-processed appropriately.}

\item{...}{Currently not in use.}
}
\value{
The result of the method dispatched by the class of the input data. Typically, this would be an object of class \code{"bnns"} containing the fitted model and associated information.
}
\description{
This is a generic function for fitting Bayesian Neural Network (BNN) models. It dispatches to methods based on the class of the input data.
}
\details{
The function serves as a generic interface to different methods of fitting Bayesian Neural Networks. The specific method dispatched depends on the class of the input arguments, allowing for flexibility in the types of inputs supported.
}
\examples{
\donttest{
# Example usage with formula interface:
data <- data.frame(x1 = runif(10), x2 = runif(10), y = rnorm(10))
model <- bnns(y ~ -1 + x1 + x2,
  data = data, L = 1, nodes = 2, act_fn = 1,
  iter = 1e1, warmup = 5, chains = 1
)
}
# See the documentation for bnns.default for more details on the default implementation.

}
\references{
\enumerate{
\item Bishop, C.M., 1995. Neural networks for pattern recognition. Oxford university press.
\item Carpenter, B., Gelman, A., Hoffman, M.D., Lee, D., Goodrich, B., Betancourt, M., Brubaker, M.A., Guo, J., Li, P. and Riddell, A., 2017. Stan: A probabilistic programming language. Journal of statistical software, 76.
\item Neal, R.M., 2012. Bayesian learning for neural networks (Vol. 118). Springer Science & Business Media.
}
}
\seealso{
\code{\link{bnns.default}}
}
