% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnnSurvival.R
\name{bnnSurvival}
\alias{bnnSurvival}
\title{Bagged k-nearest neighbors survival prediction}
\usage{
bnnSurvival(formula, data, k = max(1, nrow(data)/10),
  num_base_learners = 50, num_features_per_base_learner = NULL,
  metric = "mahalanobis", weighting_function = function(x) {     x * 0 + 1
  }, replace = TRUE, sample_fraction = NULL)
}
\arguments{
\item{formula}{Object of class formula or character describing the model to fit.}

\item{data}{Training data of class data.frame.}

\item{k}{Number nearest neighbors to use. If a vector is given, the optimal k of these values is found using 5-fold cross validation.}

\item{num_base_learners}{Number of base learners to use for bootstrapping.}

\item{num_features_per_base_learner}{Number of features randomly selected in each base learner. Default: all.}

\item{metric}{Metric d(x,y) used to measure the distance between observations. Currently only "mahalanobis".}

\item{weighting_function}{Weighting function w(d(,x,y)) used to weight the observations based on their distance.}

\item{replace}{Sample with or without replacement.}

\item{sample_fraction}{Fraction of observations to sample in [0,1]. Default is 1 for \code{replace=TRUE}, and 0.6321 for \code{replace=FALSE}.}
}
\value{
bnnSurvivalEnsemble object. Use predict() with a new data set to predict survival probabilites.
}
\description{
Bootstrap aggregated (bagged) version of the k-nearest neighbors survival probability prediction method (Lowsky et al. 2013). 
In addition to the bootstrapping of training samples, the features can be subsampled in each base learner.
}
\details{
For a description of the k-nearest neighbors survival probability prediction method see (Lowsky et al. 2013). 
Please note, that parallel processing, as currently implemented, does not work on Microsoft Windows platforms.

The weighting function needs to be defined for all distances >= 0. 
The default function is constant 1, a possible alternative is w(x) = 1/(1+x).

To use the non-bagged version as in Lowsky et al. 2013, use \code{num_base_learners=1}, \code{replace=FALSE} and \code{sample_fraction=1}.
}
\examples{
require(bnnSurvival)

## Use only 1 core
options(mc.cores = 1)

## Load a dataset and split in training and test data
require(survival)
n <- nrow(veteran)
idx <- sample(n, 2/3*n)
train_data <- veteran[idx, ]
test_data <- veteran[-idx, ]

## Create model with training data and predict for test data
model <- bnnSurvival(Surv(time, status) ~ trt + karno + diagtime + age + prior, train_data, 
                     k = 20, num_base_learners = 10, num_features_per_base_learner = 3)
result <- predict(model, test_data)

## Plot survival curve for the first observations
plot(timepoints(result), predictions(result)[1, ])

}
\author{
Marvin N. Wright
}
\references{
Lowsky, D.J. et al. (2013). A K-nearest neighbors survival probability prediction method. Stat Med, 32(12), 2062-2069.
}
\seealso{
\code{\link[=predict,bnnSurvivalEnsemble-method]{predict}}
}

