% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_false.R
\name{table_false}
\alias{table_false}
\title{Make table of false positives and false negatives in laboratory results}
\usage{
table_false(select_analyte, dat = bs_df)
}
\arguments{
\item{select_analyte}{the selected analyte for this table}

\item{dat}{data frame with all data needed as described in `bs_prep_and_analysis`.}
}
\value{
table of false positive and false negative results
}
\description{
Make a table with estimated confidence intervals for false negatives and
false positives for an analyte in the data set.
}
\details{
False negatives are the number of laboratory results that missed a spiked
value. For the false negative rate, the numerator is the number of laboratory
results less than detection level for spiked samples. The denominator is the
number or spiked samples.

False positives are the number of laboratory results above detection level
when the analyte identified by the laboratory was not in the spiked sample.
For the false positive rate, the numerator is the number of false positives.
The denominator is the number of false positives plus number of true
negatives.

The total error rate is the total number of laboratory results with either
false negative or false positive results divided by the total number of
laboratory results.
}
\examples{
example_spike_data <- system.file('extdata', 'spikevals.csv', package = 'blindspiker')
example_lab_data <- system.file('extdata', 'labvals.csv', package = 'blindspiker')
example_df <- bs_prep_and_analysis(spike_data = example_spike_data, lab_data = example_lab_data)
table_false(select_analyte = "Sr-90", dat = example_df)

}
