% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blackmarbler.R
\name{wget_h5_files}
\alias{wget_h5_files}
\title{Download h5 files using wget}
\usage{
wget_h5_files(roi_sf = NULL, product_id, date, h5_dir, bearer)
}
\arguments{
\item{roi_sf}{Region of interest; sf polygon. Must be in the \href{https://epsg.io/4326}{WGS 84 (epsg:4326)} coordinate reference system. If \code{NULL}, all \code{h5} files for the inputted date(s) are downloaded.}

\item{product_id}{One of the following:
\itemize{
\item \code{"VNP46A1"}: Daily (raw)
\item \code{"VNP46A2"}: Daily (corrected)
\item \code{"VNP46A3"}: Monthly
\item \code{"VNP46A4"}: Annual
}}

\item{date}{Date(s) to download \code{h5} files.
\itemize{
\item For \code{product_id}s \code{"VNP46A1"} and \code{"VNP46A2"}, a date (eg, \code{"2021-10-03"}).
\item For \code{product_id} \code{"VNP46A3"}, a date or year-month (e.g., \code{"2021-10-01"}, where the day will be ignored, or \code{"2021-10"}).
\item For \code{product_id} \code{"VNP46A4"}, year or date  (e.g., \code{"2021-10-01"}, where the month and day will be ignored, or \code{2021}).
}}

\item{h5_dir}{Path to download \code{h5} files to.}

\item{bearer}{NASA bearer token. For instructions on how to create a token, see \href{https://github.com/worldbank/blackmarbler#bearer-token-}{here}.}
}
\value{
\code{NULL}
}
\description{
Download h5 files from from \href{https://blackmarble.gsfc.nasa.gov/}{NASA Black Marble data} using \code{wget}. The wget_h5_files() function requires the wget command line tool to be installed on your system. If you do not have wget installed, please install it from https://www.gnu.org/software/wget/.
}
\examples{
\dontrun{
# Define bearer token
bearer <- "BEARER-TOKEN-HERE"

# sf polygon of Ghana
library(geodata)
roi_sf <- gadm(country = "GHA", level=0, path = tempdir()) \%>\% st_as_sf()

# h5 files for Ghana for October 3, 2021
download_h5_files(roi_sf = roi_sf,
                  product_id = "VNP46A2",
                  date = "2021-10-03",
                  h5_dir = getwd(),        
                  bearer = bearer)

# Make raster using h5_files
ken_202103_r <- bm_raster(roi_sf = roi_sf,
                          product_id = "VNP46A3",
                          date = "2021-03-01",
                          bearer = bearer,
                          h5_dir = getwd())

}

}
\author{
Robert Marty \href{mailto:rmarty@worldbank.org}{rmarty@worldbank.org}
}
