% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zicreg-methods.R
\name{extract.zicreg}
\alias{extract.zicreg}
\title{Texreg for zicreg objects}
\usage{
\method{extract}{zicreg}(model, CI = NULL, id = TRUE, ...)
}
\arguments{
\item{model}{A zicreg model object, returned by \code{\link{zic.reg}}.}

\item{CI}{The two-tailed confidence level, if desired in the resulting
\code{\link[texreg]{texreg}} object.}

\item{id}{Logical indicating whether to prepend equation identifiers to
coefficient names (\code{ct_} for count parameters, \code{zi_} for zero-inflated parameters)}

\item{...}{Ignored.}
}
\value{
A \code{\link[texreg]{texreg-class}} object, as produced by
\code{\link[texreg]{createTexreg}}, which can interface with all of that
package's generics. See 'Examples.'
}
\description{
This is a method for the \code{\link[texreg]{extract}} generic
to be used with objects that are output from the \code{\link{zic.reg}}
function. The results can then interface with the
\code{\link[texreg]{texreg-package}}, as shown in examples below.
}
\examples{
# Simulate some zip data
n=1000
x = cbind(1, rnorm(n))
z = cbind(1, rbeta(n, 4, 8))
b = c(1, 2.2)
g = c(-1, 1.7)
lam = exp(x \%*\% b)
psi = plogis(z \%*\% g)


y = bizicount::rzip(n, lambda = lam, psi=psi)
dat = cbind.data.frame(x = x[,-1], z = z[,-1], y = y)

# estimate model

mod = zic.reg(y ~ x | z, data = dat)


### Output to table with texreg

# extract information

tr_obj_se = texreg::extract(mod)
tr_obj_ci = texreg::extract(mod, CI = .95)

# output to latex, single table

texreg::texreg(list(tr_obj_se, tr_obj_ci))

# output to plain text, multiple tables

texreg::screenreg(tr_obj_se)
texreg::screenreg(tr_obj_ci)
}
\references{
Leifeld, Philip (2013). texreg: Conversion of Statistical Model
Output in R to LaTeX and HTML Tables. Journal of Statistical Software,
55(8), 1-24. URL http://dx.doi.org/10.18637/jss.v055.i08.
}
\seealso{
\code{\link[texreg]{extract}}, \code{\link[texreg]{createTexreg}},
\code{\link[bizicount]{zic.reg}}
}
\author{
John Niehaus
}
