% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-fit.R
\name{smoketest_floor_elpd_invariance}
\alias{smoketest_floor_elpd_invariance}
\title{Smoke Test for FLOOR ELPD Invariance}
\usage{
smoketest_floor_elpd_invariance(
  DT,
  stan_code,
  floors = c(-1e+06, -1e+08, -10000),
  spec = "C",
  controls = character(0),
  k_grid = 0:1,
  hs_grid = data.frame(hs_tau0 = c(0.1, 0.5), hs_slab_scale = c(1, 5), hs_slab_df = 4),
  hs_rows = 1:2,
  iter_warmup = 200,
  iter_sampling = 200,
  chains = 2,
  seed = 123,
  verbose = TRUE
)
}
\arguments{
\item{DT}{Data.table with the data.}

\item{stan_code}{Character; Stan model code.}

\item{floors}{Numeric vector of FLOOR values to test.}

\item{spec}{Character; model specification.}

\item{controls}{Character vector of control variables.}

\item{k_grid}{Integer vector of lag values to test.}

\item{hs_grid}{Data.frame with horseshoe hyperparameter grid.}

\item{hs_rows}{Integer vector; which rows of hs_grid to use.}

\item{iter_warmup}{Integer; warmup iterations.}

\item{iter_sampling}{Integer; sampling iterations.}

\item{chains}{Integer; number of chains.}

\item{seed}{Integer; random seed.}

\item{verbose}{Logical; print progress messages.}
}
\value{
A list with components:
\item{same_order}{Logical; TRUE if ranking is identical across all FLOOR values.}
\item{floors}{The tested FLOOR values.}
\item{tables}{List of result tables for each FLOOR.}
\item{combined}{Combined data.frame of all results.}
\item{rank_signatures}{Character vector of ranking signatures.}
}
\description{
Tests that the ELPD ranking is invariant to different FLOOR penalty values
in the Stan model.
}
