% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor.R
\name{read_bma_all}
\alias{read_bma_all}
\title{Read and consolidate BMA weight tables}
\usage{
read_bma_all(dir_csv, dir_out, stop_if_empty = TRUE, verbose = TRUE)
}
\arguments{
\item{dir_csv}{Character scalar; directory where BMA CSV files are
expected (for example \code{"bma_weights_specC_ctrl*.csv"}).}

\item{dir_out}{Character scalar; output directory used during the
experiment, which may contain BMA files or a fallback RDS object.}

\item{stop_if_empty}{Logical; if \code{TRUE}, an informative error
is thrown when no valid BMA tables are found. If \code{FALSE}, a
warning is issued and an empty tibble is returned.}

\item{verbose}{Logical; if \code{TRUE}, prints diagnostic messages
about the search paths, files found, and detected ELPD column.}
}
\value{
A data frame with all BMA tables stacked and an added
\code{combo_id} column (source identifier) and a \code{combo}
column (control combo). If nothing is found and
\code{stop_if_empty = FALSE}, an empty tibble is returned.
}
\description{
Searches for BMA weight CSV files produced by the Hurdle-NB model,
reads them using automatic delimiter detection, and returns a single
stacked data frame with normalized column names and a combo
identifier.
}
\details{
The function:
\itemize{
\item Looks for CSV files matching the pattern
\code{"bma_weights_specC_ctrl*.csv"} in \code{dir_csv}, and if
none are found, searches recursively in \code{dir_out}.
\item Reads each candidate file via \code{rc_auto()} and keeps only
non-empty data frames.
\item If no CSV files are usable, optionally falls back to an RDS
file \code{"experimento_mejorado_all.rds"} under \code{dir_out}
and tries to extract BMA tables from \code{allobj$bma}.
\item Normalizes column names with \code{normalize_names()}, ensures
a \code{combo} column exists, detects the ELPD column, and sorts
rows by decreasing ELPD.
}
}
