% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_extract.R
\name{bm_extract}
\alias{bm_extract}
\alias{bm_extract.bm_matrix}
\alias{bm_extract.bm_list}
\alias{bm_extract.magick-image}
\alias{bm_extract.nativeRaster}
\alias{bm_extract.raster}
\title{Extract part of a bitmap}
\usage{
bm_extract(x, ...)

\method{bm_extract}{bm_matrix}(x, rows = seq_len(nrow(x)), cols = seq_len(ncol(x)), ...)

\method{bm_extract}{bm_list}(x, ...)

\method{bm_extract}{`magick-image`}(x, rows = seq_len(bm_heights(x)), cols = seq_len(bm_widths(x)), ...)

\method{bm_extract}{nativeRaster}(x, rows = seq_len(nrow(x)), cols = seq_len(ncol(x)), ...)

\method{bm_extract}{raster}(x, rows = seq_len(nrow(x)), cols = seq_len(ncol(x)), ...)
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{"magick-image"}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{"raster"}  object.}

\item{...}{Additional arguments to be passed to or from methods.}

\item{rows, cols}{Integer vectors of rows and columns to extract.
Rows are indexed from the \strong{bottom} of the image.}
}
\description{
\code{bm_extract()} can be used to extract part of a bitmap.
For \code{\link[=bm_bitmap]{bm_bitmap()}} and \code{\link[=bm_pixmap]{bm_pixmap()}} objects it is a wrapper around [\code{[}()] with \code{drop = FALSE} for convenience in pipes.
}
\examples{
corn <- farming_crops_16x16()$corn$portrait
corn_top <- bm_extract(corn, rows = 9:16)
all.equal(corn_top, corn[9:16, ])
if (cli::is_utf8_output() && cli::num_ansi_colors() >= 256L) {
  print(corn_top, bg = "cyan", compress = "v")
}
}
\seealso{
[\verb{[.bm_matrix}()], \code{\link[=bm_trim]{bm_trim()}}
}
