% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importImage.R
\name{importImage}
\alias{importImage}
\title{Import an Image File}
\usage{
importImage(path2file)
}
\arguments{
\item{path2file}{path to file}
}
\value{
An image of class 'cimg'.
}
\description{
This function is a wrapper to the \code{\link[imager]{load.image}} and
\code{\link[magick]{image_read}} functions, and imports an image file and
returns the image as a 'cimg' object. The following file formats are
supported: TIFF, PNG, JPG/JPEG, and BMP. In the event that the image in
question contains an alpha channel, that channel is omitted.
}
\examples{
path2img <- system.file("images/beads_large1.bmp", package = 'biopixR')
img <- importImage(path2img)
img |> plot()

path2img <- system.file("images/beads_large2.png", package = 'biopixR')
img <- importImage(path2img)
img |> plot()
}
