% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_light_colour}
\alias{is_light_colour}
\title{Determine if a Colour is Light}
\usage{
is_light_colour(colour)
}
\arguments{
\item{colour}{A colour specification (hex code, named colour, etc.)}
}
\value{
Logical. TRUE if the colour is light (luminance > 0.5), FALSE if dark.
}
\description{
Internal helper function to determine whether a colour is light or dark
for appropriate font colour selection (black text on light backgrounds,
white text on dark backgrounds).
}
\details{
Uses standard luminance calculation: 0.299\emph{R + 0.587}G + 0.114*B,
normalized to 0-1 scale. Coefficients reflect human eye sensitivity to
different colours (green > red > blue).
}
\keyword{internal}
