% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_analysis.R
\name{pls_cross_validate}
\alias{pls_cross_validate}
\title{Cross-validate PLS models}
\usage{
pls_cross_validate(
  X,
  Y,
  ncomp,
  folds = 5L,
  type = c("kfold", "loo"),
  algorithm = c("simpls", "nipals", "kernelpls", "widekernelpls"),
  backend = "arma",
  metrics = c("rmse", "mae", "r2"),
  seed = NULL,
  parallel = c("none", "future"),
  future_seed = TRUE,
  ...
)
}
\arguments{
\item{X}{Predictor matrix as accepted by \code{\link[=pls_fit]{pls_fit()}}}

\item{Y}{Response matrix or vector as accepted by \code{\link[=pls_fit]{pls_fit()}}}

\item{ncomp}{Integer; components grid to evaluate.}

\item{folds}{Number of folds (ignored when \code{type = "loo"}).}

\item{type}{Either "kfold" (default) or "loo".}

\item{algorithm}{Backend algorithm: "simpls", "nipals", "kernelpls" or
"widekernelpls".}

\item{backend}{Backend passed to \code{\link[=pls_fit]{pls_fit()}}.}

\item{metrics}{Metrics to compute (subset of "rmse", "mae", "r2").}

\item{seed}{Optional seed for reproducibility.}

\item{parallel}{Logical or character; same semantics as in \code{\link[=pls_bootstrap]{pls_bootstrap()}}.}

\item{future_seed}{Logical or integer; reproducible seeds for parallel evaluation.}

\item{...}{Passed to \code{\link[=pls_fit]{pls_fit()}}.}
}
\value{
A list containing per-fold metrics and their summary across folds.
}
\description{
Cross-validate PLS models
}
\examples{
set.seed(123)
X <- matrix(rnorm(60), nrow = 20)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(20, sd = 0.1)
pls_cross_validate(X, y, ncomp = 2, folds = 3)
}
