% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_lav_betaselect.R
\name{coef.lav_betaselect}
\alias{coef.lav_betaselect}
\title{Coefficients of a 'lav_betaselect'-Class Object}
\usage{
\method{coef}{lav_betaselect}(object, drop_na = FALSE, ...)
}
\arguments{
\item{object}{The output of
\code{\link[=lav_betaselect]{lav_betaselect()}}.}

\item{drop_na}{Logical. Whether betas-select
with \code{NA} are dropped. Default is
\code{FALSE}.}

\item{...}{Optional arguments. Not
used.}
}
\value{
A numeric vector: The betas-select
in the object. The names of parameters
follow the convention in \code{lavaan}.
}
\description{
Return the betas-select
in a 'lav_betaselect'-class object.
}
\details{
It just extracts and
returns the column \code{est} from
the object: the betas-select, with
selected variables standardized.
}
\examples{

library(lavaan)
# Need to mean-center iv and mod
data_test_medmod$iv <- data_test_medmod$iv - mean(data_test_medmod$iv)
data_test_medmod$mod <- data_test_medmod$mod - mean(data_test_medmod$mod)
mod <-
"
med ~ iv + mod + iv:mod
dv ~ med + iv
"
fit <- sem(mod,
           data_test_medmod,
           fixed.x = TRUE)
summary(fit)
fit_beta <- lav_betaselect(fit,
                           to_standardize = c("iv", "dv"))
coef(fit_beta)

}
\seealso{
\code{\link[=lav_betaselect]{lav_betaselect()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
