% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_model_data.R
\name{generate_model_data}
\alias{generate_model_data}
\title{generate model data for testing purposes}
\usage{
generate_model_data(
  N_t = 24,
  region_coeffs = c(5, 0.5),
  c_region = c(-1, 2),
  reporting_freq = NULL
)
}
\arguments{
\item{N_t}{number of time-points}

\item{region_coeffs}{vector of coefficients for regions determining kit orders}

\item{c_region}{logit probability of kit use per region}

\item{reporting_freq}{The frequency that distribution data is provided.
If \code{NULL} distribution frequency matches orders frequency}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}}
\describe{
\item{Orders}{Kit orders per time and region}
\item{regions}{Numeric index indicating region of orders and distributions}
\item{Reported_Used}{Number of kits reported as used}
\item{Reported_Distributed}{Number of kits reported as distributed}
\item{p_use}{Probability that a kit was used}
\item{p_reported}{Probability that a distributed kit was reported}
\item{times}{Index for time}
\item{region_name}{String index for the region}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Simulate kits ordered and kits distributed for a set number of regions and
time-points.

The kits ordered simulation is a simple square-term multiplied by \code{region_coeffs}.
For example if \code{region_coeffs = c(1,2)} then the number of kits ordered at
month 12 are \code{c(1,2) * 12^2 = c(144,288)}.

The probability of kit use in time is assumed to increase linearly in inverse
logit space at a constant rate \code{0.1}.
The probability of reporting for each month and region is iid distributed
\eqn{logit^{-1}(p) \sim N(2,5)} which produces a mean reporting rate
of approximately 88\%
}
\seealso{
Other data generation: 
\code{\link{model_random_walk_data}()}
}
\concept{data generation}
