% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calc_aucs}
\alias{calc_aucs}
\title{Calculate Area-Under-the-Curve (AUC) Metrics for Delay Discounting Data}
\usage{
calc_aucs(dat)
}
\arguments{
\item{dat}{A data frame containing delay discounting data.
It must include the following columns:
\itemize{
\item \code{id}: Participant or group identifier.
\item \code{x}: Delay values (e.g., in days).
\item \code{y}: Indifference point values (e.g., subjective value of the delayed reward).
}}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{id}: The participant or group identifier.
\item \code{auc_regular}: The regular AUC, calculated using the raw delay values.
\item \code{auc_log10}: The log10 AUC, calculated using logarithmically transformed delay values.
\item \code{auc_rank}: The rank AUC, calculated using ordinally scaled delay values.
}
}
\description{
This function calculates three types of Area-Under-the-Curve (AUC) metrics for delay discounting data:
regular AUC (using raw delays), log10 AUC (using logarithmically scaled delays), and ordinal AUC (using ordinally scaled delays).
These metrics provide different perspectives on the rate of delay discounting.
}
\examples{
# Example data
data <- data.frame(
  id = rep("P1", 6),
  x = c(1, 7, 30, 90, 180, 365),
  y = c(0.8, 0.5, 0.3, 0.2, 0.1, 0.05)
)

# Calculate AUC metrics for a single participant
calc_aucs(data)
}
