% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-classes.R, R/utils-show-query.R
\name{show_query.bcdc_promise}
\alias{show_query.bcdc_promise}
\alias{show_query.bcdc_sf}
\alias{show_query}
\title{Show SQL and URL used for Web Feature Service request from B.C. Data Catalogue}
\usage{
\method{show_query}{bcdc_promise}(x, ...)

\method{show_query}{bcdc_sf}(x, ...)
}
\arguments{
\item{x}{object of class bcdc_promise or bcdc_sf}
}
\description{
Display Web Feature Service query CQL

See \code{dplyr::\link[dplyr:explain]{show_query}} for details.
}
\section{Methods (by class)}{
\itemize{
\item \code{show_query(bcdc_promise)}: show_query.bcdc_promise

\item \code{show_query(bcdc_sf)}: show_query.bcdc_promise

}}
\examples{
\donttest{
try(
  bcdc_query_geodata("bc-environmental-monitoring-locations") \%>\%
    filter(PERMIT_RELATIONSHIP == "DISCHARGE") \%>\%
    show_query()
)
  }

\donttest{
try(
  air <- bcdc_query_geodata("bc-airports") \%>\%
    collect()
)

try(
  show_query(air)
)
}
}
\keyword{internal}
