% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_rna_to_dna.R
\name{write.rna_to_dna}
\alias{write.rna_to_dna}
\title{Convert RNA file to DNA file}
\usage{
write.rna_to_dna(input_file, output_dir = "")
}
\arguments{
\item{input_file}{The name of the input multi FASTA file.}

\item{output_dir}{The directory where the output file will be saved. If not given,
the output file will be saved in the same directory as the input file.}
}
\value{
A character string specifying the path to the output FASTA file.
}
\description{
This function reads a multi FASTA file containing RNA sequences, converts each RNA sequence to DNA sequence,
and writes the DNA sequences to a new multi FASTA file. The output file name is generated from the input file
name with the suffix '_rna.fasta'.
}
\examples{
#sample_file_path <- system.file("extdata", "sample3_fa.fasta", package = "baseq")
#tempdir <- tempdir()
#temp_file_path <- file.path(tempdir, basename(sample_file_path))
#file.copy(sample_file_path, temp_file_path, overwrite = TRUE)
#write.rna_to_dna(temp_file_path, output_dir = tempdir)

# Write to working directory
# write.rna_to_dna(file_path)

# Write to custom directory
# write.rna_to_dna(file_path, output_dir = "/path/to/directory/")

}
