% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate.R
\name{truncate_to_quantile}
\alias{truncate_to_quantile}
\title{Truncate reporting_triangle to quantile-based maximum delay}
\usage{
truncate_to_quantile(x, p = 0.99)
}
\arguments{
\item{x}{A reporting_triangle object}

\item{p}{Numeric value between 0 and 1 indicating the quantile cutoff.
For example, p = 0.99 truncates to the delay at which 99\% of cases have
been reported. Default is 0.99.}
}
\value{
A reporting_triangle object truncated to the maximum quantile delay,
or the original object if no truncation is needed
}
\description{
Automatically determines an appropriate maximum delay based on when a
specified proportion of cases have been reported (CDF cutoff). This is useful
for reducing computational burden when most cases are reported within a
shorter delay window.
}
\examples{
data_as_of_df <- syn_nssp_df[syn_nssp_df$report_date <= "2026-04-01", ]
# Create triangle, max_delay is automatically computed
rep_tri <- suppressMessages(as_reporting_triangle(data = data_as_of_df))

# Check the maximum delay in the triangle
ncol(rep_tri)

# Truncate to 99th percentile of reporting
rep_tri_trunc <- truncate_to_quantile(rep_tri, p = 0.99)
ncol(rep_tri_trunc)

# More aggressive truncation
rep_tri_trunc90 <- truncate_to_quantile(rep_tri, p = 0.90)
ncol(rep_tri_trunc90)
}
\seealso{
Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.data.frame.reporting_triangle}()},
\code{\link{as.matrix.reporting_triangle}()},
\code{\link{as_ChainLadder_triangle}()},
\code{\link{as_reporting_triangle}()},
\code{\link{as_reporting_triangle.data.frame}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{as_reporting_triangle.triangle}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_from_dates}()},
\code{\link{get_delays_unit}()},
\code{\link{get_max_delay}()},
\code{\link{get_mean_delay}()},
\code{\link{get_quantile_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_report_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{new_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_delay}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
