% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chadwick_installation.R
\name{chadwick_path}
\alias{chadwick_path}
\alias{chadwick_is_installed}
\alias{chadwick_find_lib}
\alias{chadwick_set_ld_library_path}
\alias{chadwick_ld_library_path}
\title{Check Chadwick installation}
\usage{
chadwick_path()

chadwick_is_installed()

chadwick_find_lib()

chadwick_set_ld_library_path()

chadwick_ld_library_path()
}
\value{
If Chadwick is not installed \code{NULL}. If Chadwick is installed, the path to the \code{cwevent} binary.

\code{TRUE} or \code{FALSE}

Path to the Chadwick shared library.
}
\description{
Utility functions to help ensure that Chadwick is set up correctly.

The easiest way for the \href{https://github.com/chadwickbureau/chadwick/releases}{Chadwick CLI}
tools to work on *nix systems is to
set the \code{LD_LIBRARY_PATH} environment variable. Unfortunately this environment
variable is not set by default during the Chadwick installation.

\code{chadwick_ld_library_path()} checks to find the Chadwick shared libraries, and then
set the \code{LD_LIBRARY_PATH} environment variable.
If \code{chadwick_ld_library_path()} returns \code{TRUE}, the \code{cwevent} command line program
that \code{\link{retrosheet_data}}
depends on should work.

The other functions documented here are mostly for internal use.
}
\examples{
chadwick_path()

chadwick_is_installed()

chadwick_find_lib()
\dontrun{
if (chadwick_ld_library_path()) {
  retrosheet_data(tempdir())
}
}
}
\seealso{
\code{\link[=retrosheet_data]{retrosheet_data()}}
}
