% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oop_s3.R
\name{\%contains\%.bandicoot_oop}
\alias{\%contains\%.bandicoot_oop}
\title{S3 method of performing membership test operator of a
\code{bandicoot_oop} object}
\usage{
\method{\%contains\%}{bandicoot_oop}(x, y)
}
\arguments{
\item{x}{\code{bandicoot_oop} object.}

\item{y}{Another object.}
}
\value{
A Boolean value.
}
\description{
This function performs the membership test operator using the
\code{..contains..()} method.
If it is not applicable, error will be raised.
}
\examples{
COMPANY <- new_class(class_name = "COMPANY")
company <- COMPANY$instantiate
register_method(COMPANY,
                ..init.. = function(name, age) {
                  self$name <- name
                  self$age <- age
                })
register_method(COMPANY,
                ..contains.. = function(y) y \%in\% self$name)

good_company <- company(c("patrick", "james"),
                        c(33, 34))
good_company \%contains\% "patrick"

}
