% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oop.R
\name{copy_attr}
\alias{copy_attr}
\title{Copy attributes and methods from classes or instances}
\usage{
copy_attr(
  env,
  ...,
  avoid = c("..method_env..", "..init_call.."),
  class_name = env$..type..
)
}
\arguments{
\item{env}{Environment. The destination environment.}

\item{...}{Environments. Source environments.}

\item{avoid}{Character. Names that don't want to be copied.}

\item{class_name}{Character. Name of the class the method is defined.
This is important for \code{super()} to resolve the correct parent class.}
}
\value{
Return the object itself.
}
\description{
This function copy attributes and methods from classes or instances to
class or instance.
}
\details{
Multiple classes or instances can be provided in \code{...}, where the right one
will override the left one if they have the same attribute or method name.
Attributes or methods that don't want to be copied can be specified in
\code{avoid}.
}
\examples{

test <- new.env()
names(BASE)
copy_attr(test, BASE, avoid = c("..method_env..", "..init_call..", "..dir.."))
names(test)

}
