% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silco.R
\name{silco}
\alias{silco}
\title{Calculate concentration(C0) of Silica from samples}
\usage{
silco(m, y, c, data, output_dir = tempdir())
}
\arguments{
\item{m}{The slope value (replace with the actual slope from plotStdC).}

\item{y}{The y-intercept (replace with the actual intercept from tdgraph).}

\item{c}{The intercept (replace with the actual intercept from plotStdC).}

\item{data}{Path to the CSV file containing output values from plotStdC.}

\item{output_dir}{The directory where the output CSV file should be saved. Defaults to the temporary directory (tempdir()).}
}
\value{
A data frame with sample_id and C0 values.
}
\description{
This function calculates C0 values based on the provided slope (m) and
y-intercept (y) from the tdgraph function. The sample data is loaded
from a CSV file and the intercept (c) from plotStdC function is used.
}
\examples{


data <- system.file("extdata", "WLO6output.csv", package = "bSi")
m <- 5.6073  # Replace with the actual slope from plotStdC
y <- 0.1234  # Replace with the actual intercept from tdgraph
c <- 0.5678  # Replace with the actual intercept from plotStdC
C0 <- silco(m, y, c, data)

}
