% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bodyBuilder.R
\name{POSTbody_builder_directions_geojson}
\alias{POSTbody_builder_directions_geojson}
\title{Build GeoJSON Body for Route Directions}
\usage{
POSTbody_builder_directions_geojson(origin, destination, waypoints = NULL)
}
\arguments{
\item{origin}{A numeric vector of coordinates (longitude, latitude) or an \code{sf}
object representing the starting point.}

\item{destination}{A numeric vector of coordinates (longitude, latitude) or an
\code{sf} object representing the end point.}

\item{waypoints}{Optional. A numeric vector, a matrix of coordinates, or an
\code{sf} object with POINT geometries for intermediate stops.}
}
\value{
A list formatted as a GeoJSON FeatureCollection, ready to be
included in the API request body.
}
\description{
Constructs the GeoJSON part of the request body for the Azure Maps Route
Directions API. This includes the origin, destination, and any waypoints.
}
\examples{
\dontrun{
origin <- c(-122.201399, 47.608678)
destination <- c(-122.201669, 47.615076)
waypoints <- c(-122.20687, 47.612002)
geojson_part <- POSTbody_builder_directions_geojson(origin, destination, waypoints)
}
}
