% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3source.R
\name{s3source}
\alias{s3source}
\title{Source from S3}
\usage{
s3source(object, bucket, ..., opts = NULL)
}
\arguments{
\item{object}{Character string with the object key, or an object of class \dQuote{s3_object}. In most cases, if \code{object} is specified as the latter, \code{bucket} can be omitted because the bucket name will be extracted from \dQuote{Bucket} slot in \code{object}.}

\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}

\item{opts}{Additional arguments passed to \code{\link{get_object}} for retrieving the R syntax file.}
}
\value{
See \code{\link[base]{source}}
}
\description{
Source R code (a la \code{\link[base]{source}}) from S3
}
\examples{
\dontrun{
# create bucket
b <- put_bucket("myexamplebucket")

# save some code to the bucket
cat("x <- 'hello world!'\nx", file = "example.R")
put_object("example.R", object = "example.R", bucket = b)
get_bucket(b)

# source the code from the bucket
s3source(object = "example.R", bucket = b, echo = TRUE)

# cleanup
unlink("example.R")
delete_object(object = "example.R", bucket = b)
delete_bucket("myexamplebucket")
}
}
\seealso{
\code{\link{s3saveRDS}},\code{\link{s3save}}, \code{\link{get_object}}
}
