% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{create_group}
\alias{create_group}
\alias{update_group}
\alias{delete_group}
\alias{get_group_users}
\alias{list_groups}
\alias{add_user}
\alias{remove_user}
\title{Manage IAM User Groups}
\usage{
create_group(group, path, ...)

update_group(group, name, path, ...)

delete_group(group, ...)

get_group_users(group, n, marker, ...)

list_groups(user, n, marker, path, ...)

add_user(user, group, ...)

remove_user(user, group, ...)
}
\arguments{
\item{group}{A character string containing a group name or an object of class \dQuote{iam_group}.}

\item{path}{A character string specifying a path prefix in which to locate user(s), role(s), etc. See \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{Reference Identifiers} on the AWS Documentation for more information.}

\item{\dots}{Additional arguments passed to \code{\link{iamHTTP}}.}

\item{name}{A character string specifying the new name for the group.}

\item{n}{An integer specifying the number of responses to return.}

\item{marker}{A character string specifying a marker (from a previous response) to use in paginating results}

\item{user}{A character string specifying a user name.}
}
\value{
\code{create_group} and \code{get_group} return objects of class \dQuote{iam_group}. \code{update_group} and \code{delete_group}, \code{add_user}, and \code{remove_user} return a logical \code{TRUE} (if successful) or an error. \code{list_groups} returns a list of IAM group objects. \code{get_group_users} returns a list of objects of class \dQuote{iam_user}, with a \dQuote{iam_group} attribute.
}
\description{
Retrieve, create, update, and delete IAM user groups
}
\examples{
\dontrun{
 list_groups()

# create group
(g <- create_group("example"))
# rename
update_group(g, "example2")
list_groups()

# create example user
u <- create_user("example-user")
# add user to group
add_user(u, "example2")

get_group_users("example2")

# cleanup
remove_user(u, "example2")
delete_user(u)
delete_group("example2")
}
}
\seealso{
\code{\link{create_user}}, \code{\link{create_role}},
}
