% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlasapprox.R
\name{GetSimilarFeatures}
\alias{GetSimilarFeatures}
\title{GetSimilarFeatures}
\usage{
GetSimilarFeatures(organism, organ, feature, number, method)
}
\arguments{
\item{organism}{The organism you would like to query}

\item{organ}{The organ you would like to query}

\item{feature}{The feature to find similarities for}

\item{number}{The number of similar features you would like to get.}

\item{method}{The method used to compute similarity between features.
The following methods are available:
- correlation (default): Pearson correlation of the fraction_detected
- cosine: Cosine similarity/distance of the fraction_detected
- euclidean: Euclidean distance of average measurement (e.g. expression)
- manhattan: Taxicab/Manhattan/L1 distance of average measurement
- log-euclidean: Log the average measurement with a pseudocount
of 0.001, then compute euclidean distance. This tends to
highlight sparsely measured features}
}
\value{
A dataframe of similar features and their distances from the focal feature according to the method chosen
}
\description{
Get features with similar expression patterns to a specified feature in a given organism and organ.
}
\examples{
GetSimilarFeatures("h_sapiens", "lung", "PTPRC", 5, "correlation")
}
