% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_rapidity.R
\name{count_rapidity}
\alias{count_rapidity}
\title{Calculates a count of the time beneath the baseline.}
\usage{
count_rapidity(data, ycoord, ybase = NA, yinvert = FALSE,
  saveout = FALSE)
}
\arguments{
\item{data}{A dataframe with x- and y-coordinates in wide format.}

\item{ycoord}{A specified selection of the y-coordinate values within the
dataframe. The first y-coordinate value should correspond to the baseline value
of 'y'. The second y-coordinate value should be the first measure of 'y' after
the intrusion of a stress event. The last value of 'y' should correspond to
the last measurement of 'y' over the measured timeframe.}

\item{ybase}{A specified selection of the baseline of the 'y' measured variable.
Users are advised to place baseline as the first instance of the y-coordinate
values. Function defaults to use the first y-coordinate value in the series.}

\item{yinvert}{Specifies whether resilience occurs above or below the baseline
depending on the meaning of high and low 'y' values. When parameter 'yinvert'
is set to 'FALSE' (the default), it is assumed that higher numbers are indicative
of positive (i.e., desired) 'y' values (e.g., exam grade). When 'yinvert' is set
to 'TRUE', it is assumed that lower numbers are indicative of positive
(i.e., desired) 'y' values (e.g., blood pressure).}

\item{saveout}{When the parameter 'saveout' is set to 'FALSE' (the default),
a vector of calculated count_rapidity values are given for each case. When 'saveout' is
set to 'TRUE', a dataframe of the original inputted dataset is returned with a
new column of calculated count_rapidity values.}
}
\value{
When the parameter 'saveout' is set to 'FALSE', a vector of calculated
count_rapidity values are given for each case. When 'saveout' is set to 'TRUE', a
dataframe of the original inputted dataset is returned with a new column of
calculated count_rapidity values.
}
\description{
This function takes a series of y-coordinates and returns a count
of y-coordinates that fall beneath the specified baseline after
the intrusion of a stress event (i.e., rapidity).
}
\examples{
xc <- t(c(1,2,3,4,5,6,7,8,9,10))
yc <- t(c(75,53,37,25,27,35,50,75,75,75))
dataset1 <- data.frame(xc, yc)
count_rapidity(data = dataset1, ycoord = dataset1[,11:20], saveout = TRUE)
}
