% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magrittr_extensions.R
\name{iff}
\alias{iff}
\alias{iffn}
\alias{iffelse}
\title{Apply a function depending on test output}
\usage{
iff(obj, test, fun, ...)

iffn(obj, test, fun, ...)

iffelse(obj, test, true_fun, false_fun, ...)
}
\arguments{
\item{obj}{object to apply test and fun to}

\item{test}{logical or function to apply to test}

\item{fun}{function to apply}

\item{...}{passed on to test}

\item{true_fun}{function to apply when test is true}

\item{false_fun}{function to apply when test is false}
}
\value{
Output of function \code{fun} applied to the original value or the
original value, depending on the test.
}
\description{
\code{iff} returns output of the function if and only if test is \code{TRUE}.
\code{iffn} returns output of the function if and only if test is \code{FALSE}.
They return the original value otherwise.
\code{iffelse} returns output of the first function if test is \code{TRUE},
output of the second function otherwise.
}
\examples{
x <- 1
x \%>\%
  iff(is.na, const(0))
x <- NA
x \%>\%
  iff(is.na, const(0))

x <- 1
x \%>\%
  iff(x <= 0, function(x) { x - 2 })
x <- -1
x \%>\%
  iff(x <= 0, function(x) { x - 2 })

x <- NA
x \%>\%
  iffn(is.na, exp)
x <- 10
x \%>\%
  iffn(is.na, exp)

}
