% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcut_functions.R
\name{rarf}
\alias{rarf}
\title{Shortcut sampling function}
\usage{
rarf(x, n_synth = NULL, ...)
}
\arguments{
\item{x}{Input data. Integer variables are recoded as ordered factors with
a warning. See Details.}

\item{n_synth}{Number of synthetic samples to generate for unconditional
generation with no \code{evidence} given.
Number of synthetic samples to generate per \code{evidence} row if \code{evidence}
is provided.
If \code{NULL}, defaults to \code{nrow(x)} if no \code{evidence} is provided and to
\code{1} otherwise.}

\item{...}{Extra parameters to be passed to \code{adversarial_rf}, \code{forde}
and \code{forge}.}
}
\value{
A dataset of \code{n_synth} synthetic samples or of \code{nrow(x)} synthetic
samples if \code{n_synth} is undefined.
}
\description{
Calls \code{adversarial_rf}, \code{forde} and \code{forge}.
For repeated application, it is faster to save outputs of \code{adversarial_rf}
and \code{forde} and pass them via \code{...} or directly use \code{forge}.
}
\examples{
# Generate 150 (size of original iris dataset) synthetic samples from the iris dataset
x_synth <- rarf(iris)

# Generate 100 synthetic samples from the iris dataset
x_synth <- rarf(iris, n_synth = 100)

# Condition on Species = "setosa"
x_synth <- rarf(iris, evidence = data.frame(Species = "setosa"))

}
\references{
Watson, D., Blesch, K., Kapar, J., & Wright, M. (2023). Adversarial random
forests for density estimation and generative modeling. In \emph{Proceedings
of the 26th International Conference on Artificial Intelligence and
Statistics}, pp. 5357-5375.
}
\seealso{
\code{\link{arf}}, \code{\link{adversarial_rf}}, \code{\link{forde}}, \code{\link{forge}}
}
