% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cforde}
\alias{cforde}
\title{Compute conditional circuit parameters}
\usage{
cforde(
  params,
  evidence,
  row_mode = c("separate", "or"),
  nomatch = c("force", "na"),
  verbose = TRUE,
  stepsize = 0,
  parallel = TRUE
)
}
\arguments{
\item{params}{Circuit parameters learned via \code{\link{forde}}.}

\item{evidence}{Data frame of conditioning event(s).}

\item{row_mode}{Interpretation of rows in multi-row conditions.}

\item{nomatch}{What to do if no leaf matches a condition in \code{evidence}?
Options are to force sampling from a random leaf (\code{"force"}) or return
\code{NA} (\code{"na"}). The default is \code{"force"}.}

\item{verbose}{Show warnings, e.g. when no leaf matches a condition?}

\item{stepsize}{Stepsize defining number of condition rows handled in one for each step.}

\item{parallel}{Compute in parallel? Must register backend beforehand, e.g.
via \code{doParallel} or \code{doFuture}; see examples.}
}
\value{
List with conditions (\code{evidence_input}), prepared conditions (\code{evidence_prepped})
and leaves that match the conditions in evidence with continuous data (\code{cnt})
and categorical data (\code{cat}) as well as leaf info (\code{forest}).
}
\description{
Compute conditional circuit parameters
}
\keyword{internal}
