% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_string_to_coords.R
\name{string_to_coords}
\alias{string_to_coords}
\title{Convert strings to numerical coordinates}
\usage{
string_to_coords(coord_vector, verbose = TRUE)
}
\arguments{
\item{coord_vector}{character. A string containing potential geographic coordinates.}

\item{verbose}{logical. Whether or not to print the overall success of the function upon end.}
}
\value{
list. Contain latitude and longitude as the first and second elements,
respectively.
}
\description{
Convert character strings containing geographic coordinates to sets of numeric values through a rule-based method. Useful as most LLM experience better and more consistent results when asked to return a single string instead of two separate values.
}
\details{
Will convert all strings to N, W for consistency's sake.
In a future update the user will be able to specify the outcome format, e.g: "39°S 42°E".
}
\examples{
 example = c('N 39degrees05’53” E 26degrees21’57”', "39 ° 80 ' N , 32 ° 78 ' E",
 "30 ° 20'54.32 \" N , 78 ° 0'53.37 \" E", "19 ° 34 ’ S 29 ° 10 ° E",
 "- 25.05012 S ; - 65.49622 W", "S 12 ° 06 ’ , W 76 ° 57 ’", 
 "19 ° 34 ’ S 29 ° 10 ° E", "19 ° 32 ’ S 29 ° 08 ° E")
 string_to_coords(example)
}
