% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arakno.R
\name{buildtree}
\alias{buildtree}
\title{Create phylogenetic tree.}
\usage{
buildtree(tax, update = FALSE)
}
\arguments{
\item{tax}{A taxon name or vector with taxa names. Should be in the general form "Family_sp" or "Genus speciesname", with family or genus name plus anything to uniquely identify the species separated by "_" or " ".}

\item{update}{Whether to update the taxonomy of the backbone tree according to the WSC (2025).}
}
\value{
A phylo object with a phylogenetic tree for the community.
}
\description{
Create a phylogenetic tree based on the backbone from Macias-Hernandez et al. (2020) and the species taxonomical hierarchy.
}
\details{
Based on the backbone phylogeny of Macias-Hernandez et al. (2020). All species in tax present in the backbone are included in the output tree.
If the species is not in the backbone, or if only family or genus are known, species are inserted at the level of the most recent common ancestor of confamiliar or congenerics respectively.
If only one congeneric or confamiliar are in the backbone, the species is inserted at half the length of the corresponding edge.
}
\examples{
\dontrun{
spp = c("Atypus affinis", "Tenuiphantes tenuis", "Zodarion sp1", "Araneus diadematus")
spp = c(spp, "Zodarion sp2", "Atypus_nsp", "Nemesia ungoliant", "Linyphiidae sp1")
spp = c(spp, "Zoropsis spinimana", "Pardosa sp1", "Pardosa acorensis", "Liphistius nsp")
tree = buildtree(spp)
plot(tree)
}
}
\references{
Macías-Hernández et al. (2020). Building-up of a robust, densely sampled spider tree of life for assessing phylogenetic diversity at the community level. Diversity, 12: 288. https://doi.org/10.3390/d12080288

World Spider Catalog (2025). World Spider Catalog. Version 26. Natural History Museum Bern, online at http://wsc.nmbe.ch. doi: 10.24436/2.
}
