% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isolation-score.R
\name{score.apd_isolation}
\alias{score.apd_isolation}
\title{Predict from a \code{apd_isolation}}
\usage{
\method{score}{apd_isolation}(object, new_data, type = "numeric", ...)
}
\arguments{
\item{object}{A \code{apd_isolation} object.}

\item{new_data}{A data frame or matrix of new samples.}

\item{type}{A single character. The type of predictions to generate.
Valid options are:
\itemize{
\item \code{"numeric"} for numeric predictions.
}}

\item{...}{Not used, but required for extensibility.}
}
\value{
A tibble of predictions. The number of rows in the tibble is guaranteed
to be the same as the number of rows in \code{new_data}. The \code{score} column is the
raw prediction from \code{\link[isotree:predict.isolation_forest]{isotree::predict.isolation_forest()}} while \code{score_pctl}
compares this value to the reference distribution of the score created by
predicting the training set. A value of \emph{X} means that \emph{X} percent of the
training data have scores less than the predicted value.
}
\description{
Predict from a \code{apd_isolation}
}
\details{
About the score
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (rlang::is_installed(c("isotree", "modeldata"))) {
  library(dplyr)

  data(cells, package = "modeldata")

  cells_tr <- cells \%>\% filter(case == "Train") \%>\% select(-case, -class)
  cells_te <- cells \%>\% filter(case != "Train") \%>\% select(-case, -class)

  if_mod <- apd_isolation(cells_tr, ntrees = 10, nthreads = 1)
  score(if_mod, cells_te)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=apd_isolation]{apd_isolation()}}
}
