% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uoc_psych_thesis_formats.R
\name{uoc_psych_thesis_pdf}
\alias{uoc_psych_thesis_pdf}
\title{University of Cologne Psychology Thesis}
\usage{
uoc_psych_thesis_pdf(
  fig_caption = TRUE,
  number_sections = FALSE,
  keep_tex = TRUE,
  md_extensions = NULL,
  includes = NULL,
  ...
)
}
\arguments{
\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{number_sections}{\code{TRUE} to number section headings}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF.
Note that this argument does not control whether to keep the auxiliary
files (e.g., \file{.aux}) generated by LaTeX when compiling \file{.tex} to
\file{.pdf}. To keep these files, you may set \code{options(tinytex.clean =
FALSE)}.}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition of R Markdown. See the
\code{\link[rmarkdown]{rmarkdown_format}} for additional details.}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link[rmarkdown]{includes}} function).}

\item{...}{Further arguments to pass to
\code{\link[bookdown]{pdf_document2}} or
\code{\link[bookdown]{word_document2}}.}
}
\value{
R Markdown output format to pass to \code{\link[rmarkdown:render]{rmarkdown::render()}}.
}
\description{
Template for theses in psychology at the University of Cologne in PDF format.
}
\details{
This document template includes by default the logo of the University of
Cologne, which is protected by copyright. We have explicit permission to
distribute the logo with this template, but unauthorized use of the logo
is restricted to "students for work and presentations in the context of
their studies" or "cases where the University of Cologne acts as an
organizer or originator":

"\emph{The use of the university seal is permitted in cases where the
University of Cologne acts as an organizer or originator. This regulation
includes the use of the university seal by students for work and
presentations in the context of their studies.}

\emph{The use of the university seal by natural or legal persons outside the
University of Cologne requires written permission and is only possible in
cases where there is a sufficient connection to the University of Cologne.
If permission is to be granted for advertising purposes, the interests
of the University of Cologne must be given special consideration. The
purpose, type, and extent of the permitted use must be specified in the
permission. The permission must be in written form.}"

You can use a different logo by setting the YAML option \code{logo} to the
path of the logo file. The logo should be a PDF file.

\if{html}{\out{<div class="sourceCode">}}\preformatted{logo: 
  file: "path/to/file.pdf"
  scale: 0.5
}\if{html}{\out{</div>}}

When creating PDF documents the YAML option \code{classoption} is passed
to the class options of the LaTeX apa6 document class. In this case,
additional options are available. Refer to the \code{apa6} document class
\href{ftp://ftp.fu-berlin.de/tex/CTAN/macros/latex/contrib/apa6/apa6.pdf}{documentation}
to find out about class options such as paper size.
}
\examples{
\dontrun{
# Render skeleton
skeleton_path <- file.path(tempdir(), "thesis_skeleton.Rmd")

rmarkdown::draft(
  skeleton_path
  , system.file(
    "rmarkdown", "templates", "uoc-psych-thesis"
    , package = "apathe"
  )
  , create_dir = FALSE
  , edit = FALSE
)

rmarkdown::render(skeleton_path, quiet = TRUE)
}
}
\seealso{
\link{uoc_psych_homework_pdf}, \code{\link[bookdown:html_document2]{bookdown::pdf_document2()}}, \code{\link[bookdown:html_document2]{bookdown::word_document2()}}
}
