% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_correlation.R
\name{apa.r.compare.within.sample}
\alias{apa.r.compare.within.sample}
\title{Report difference in markdown APA style between between correlations within a sample}
\usage{
apa.r.compare.within.sample(
  formula,
  data,
  test = "pearson1898",
  alternative = "two.sided",
  show.conf.interval = NULL,
  show.N = NULL,
  show.p = NULL,
  show.statistic = NULL
)
}
\arguments{
\item{formula}{Formula for comparing correlations}

\item{data}{Project data frame name}

\item{test}{Type of significance test. If non-overlapping variables use one of "pearson1898", "dunn1969", "steiger1980", "raghunathan1996", or "silver2004".  If overlapping variables use one of pearson1898, hotelling1940, hendrickson1970, williams1959, olkin1967, dunn1969, steiger1980, meng1992, hittner2003. Default is pearson1898.}

\item{alternative}{Alternative hypothesis to pass to alternative argument of cor.test. Default is "two.sided"}

\item{show.conf.interval}{Show confidence interval or not (TRUE/FALSE). Default behavior is TRUE.}

\item{show.N}{Show sample size or not (TRUE/FALSE). Default behavior is TRUE.}

\item{show.p}{Show p-value or not (TRUE/FALSE). Default behavior is TRUE.}

\item{show.statistic}{Show test statistic or not (TRUE/FALSE). Default behavior is TRUE.}
}
\value{
R Markdown text
}
\description{
Report difference in markdown APA style between between correlations within a sample
}
\examples{

# non-overlappling variables example
apa.r.compare.within.sample(data = attitude,
  formula = ~ rating + complaints | privileges + learning)

# overlappling variables example
apa.r.compare.within.sample(data = attitude,
  formula = ~ rating + complaints | rating + learning)
}
