#' Burglaries, Washington DC, first six months of 2016
#'
#' A dataset containing the X and Y coordinates of burglaries, with
#' the start and end date and times of the crimes. Sourced from Open Data Washington DC
#' with start date in the first six months 2016. X, Y geometry for Washington DC is from
#' FIPS 1900 (crs 7058).
#'
#' @format A data frame with 1025 rows and 4 variables:
#' \describe{
#'   \item{X}{X coordinate of burglary location}
#'   \item{Y}{Y coordinate of burglary location}
#'   \item{StartDateTime}{Start date and time of the burglary in POSIXct format}
#'   \item{EndDateTime}{End date and time of the burglary in POSIXct format}
#' }
#' @source \url{https://opendata.dc.gov/}
"dcburglaries"


#' Summary output from aoristic analysis of DC burglaries
#'
#' A dataset containing the summarized output generated by aoristic.summary() 
#' on the data frame produced by the aoristic function aoristic.df(dcburglaries, ...).
#'
#' @format A data frame with 24 observations and 8 variables:
#' \describe{
#'   \item{Range}{The hour represented by the column, in 24 hour format}
#'   \item{Mon}{Sum of aoristic values for Mondays by hour}
#'   \item{Tue}{Sum of aoristic values for Tuesdays by hour}
#'   \item{Wed}{Sum of aoristic values for Wednesdays by hour}
#'   \item{Thu}{Sum of aoristic values for Thursdays by hour}
#'   \item{Fri}{Sum of aoristic values for Fridays by hour}
#'   \item{Sat}{Sum of aoristic values for Saturdays by hour}
#'   \item{Sun}{Sum of aoristic values for Sundays by hour}
#' }
"dcburgsum"

#' Residential burglaries, Manhattan borough, New York City, NY, 2019
#'
#' A dataset with a residential burglaries in the Borough of Manhattan, New York City, NY for 2019. 
#' Data include start and end date-times, and coordinates. 
#'
#' @format A data frame with 1233 rows and 6 variables:
#' \describe{
#'   \item{CMPLNT_FR_DT}{Crime from date in Date format}
#'   \item{CMPLNT_FR_TM}{Crime from time in number format}
#'   \item{CMPLNT_TO_DT}{Crime to date in Date format}
#'   \item{CMPLNT_TO_TM}{Crime to time in number format}
#'   \item{X_COORD_CD}{X coordinate of crime event in state plane format}
#'   \item{Y_COORD_CD}{Y coordinate of crime event in state plane format}
#' }
#' @source \url{https://data.cityofnewyork.us/Public-Safety/NYPD-Complaint-Data-Current-Year-To-Date-/5uac-w243/data}
"NYburg"
