% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editClusterST.R
\name{editClusterST}
\alias{editClusterST}
\title{Edit a short-term storage cluster}
\usage{
editClusterST(
  area,
  cluster_name,
  group = NULL,
  storage_parameters = NULL,
  PMAX_injection = NULL,
  PMAX_withdrawal = NULL,
  inflows = NULL,
  lower_rule_curve = NULL,
  upper_rule_curve = NULL,
  cost_injection = NULL,
  cost_withdrawal = NULL,
  cost_level = NULL,
  cost_variation_injection = NULL,
  cost_variation_withdrawal = NULL,
  constraints_properties = NULL,
  constraints_ts = NULL,
  add_prefix = TRUE,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{area}{The area where to create the cluster.}

\item{cluster_name}{Name for the cluster, it will prefixed by area name, unless you set \code{add_prefix = FALSE}.}

\item{group}{Group of the cluster, one of : \emph{{PSP_open, PSP_closed, Pondage, Battery, Other}}.
It corresponds to the type of stockage (\strong{dynamic name for Antares version >= 9.2}).}

\item{storage_parameters}{\code{list } Parameters to write in the Ini file (see \code{Note}).}

\item{PMAX_injection}{Modulation of charging capacity on an 8760-hour basis. \code{numeric} \{0;1\} (8760\emph{1)
(**\code{numeric} \{0;1\} (8760}N) noting that N >= 1 for Antares version >= 9.3**).}

\item{PMAX_withdrawal}{Modulation of discharging capacity on an 8760-hour basis. \code{numeric} \{0;1\} (8760\emph{1)
(**\code{numeric} \{0;1\} (8760}N) noting that N >= 1 for Antares version >= 9.3**).}

\item{inflows}{Algebraic deviation of the state of charge of the storage, which does not induce any power
generation or consumption on the system \code{numeric} \{<0;>0\} (8760\emph{1)
(**``numeric` \{<0;>0\} (8760}1) noting that N >= 1 for Antares version >= 9.3**).}

\item{lower_rule_curve}{This is the lower limit for filling the stock imposed each hour. \code{numeric} \{0;1\} (8760\emph{1)
(**\code{numeric} \{0;1\} (8760}N) noting that N >= 1 for Antares version >= 9.3**).}

\item{upper_rule_curve}{This is the upper limit for filling the stock imposed each hour. \code{numeric} \{0;1\} (8760\emph{1)
(**\code{numeric} \{0;1\} (8760}N) noting that N >= 1 for Antares version >= 9.3**).}

\item{cost_injection}{Penalizes the injection flowrate at each hour (€/MWh) \code{numeric} \{>0\} (8760\emph{1)
(**\code{numeric} \{>0\}  (8760}N) noting that N >= 1 for Antares version >= 9.3**).}

\item{cost_withdrawal}{Penalizes the withdrawal flowrate at each hour (€/MWh) \code{numeric} \{>0\} (8760\emph{1)
(**\code{numeric} \{>0\}  (8760}N) noting that N >= 1 for Antares version >= 9.3**).}

\item{cost_level}{Penalizes the volume of stored energy at each hour (€/MWh) \code{numeric} \{<0;>0\} (8760\emph{1)
(**\code{numeric} \{<0;>0\}  (8760}N) noting that N >= 1 for Antares version >= 9.3**).}

\item{cost_variation_injection}{Penalizes injection flowrate variation every hour (€/MWh) \code{numeric} \{>0\} (8760\emph{1)
(**\code{numeric} \{>0\}  (8760}N) noting that N >= 1 for Antares version >= 9.3**).}

\item{cost_variation_withdrawal}{Penalizes the withdrawal variation every hour (€/MWh) \code{numeric} \{>0\} (8760\emph{1)
(**\code{numeric} \{>0\}  (8760}N) noting that N >= 1 for Antares version >= 9.3**).}

\item{constraints_properties}{\code{list } Parameters (see example)}

\item{constraints_ts}{\code{list } of time series (see example)}

\item{add_prefix}{If \code{TRUE} (the default), \code{cluster_name} will be prefixed by area name.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Edit parameters and time series of an existing \code{st-storage} cluster (Antares studies >= v8.6.0).
}
\note{
Put only properties or TS value you want to edit (see \code{examples} section).
}
\examples{
\dontrun{
# study version >= "8.6.0"

# edit an existing cluster (see doc approved groups)
name_group <- "Pondage"

editClusterST(area = "areaname", 
              cluster_name = "clustername", 
              group = name_group)

# edit properties
all_params <- storage_values_default()
all_params[["efficiency"]] <- 0.9
all_params[["reservoircapacity"]] <- 1000
all_params[["initiallevel"]] <- 0.5
all_params[["withdrawalnominalcapacity"]] <- 250
all_params[["injectionnominalcapacity"]] <- 200
all_params[["initialleveloptim"]] <- TRUE

editClusterST(area = "areaname", 
              cluster_name = "clustername", 
              storage_parameters = all_params)

# edit time series
inflow_data <- matrix(3, 8760)
ratio_data <- matrix(0.7, 8760)

editClusterST(area = "areaname", 
              cluster_name = "clustername",
              PMAX_withdrawal = ratio_data, 
              inflows = inflow_data, 
              PMAX_injection = ratio_data, 
              lower_rule_curve = ratio_data, 
              upper_rule_curve = ratio_data)

# study version >= "9.2" (new parameters and TS)

# edit group (dynamic)
name_group <- "MyOwnGroup"

editClusterST(area = "areaname", 
              cluster_name = "clustername", 
              group = name_group)

# edit properties
my_parameters <- storage_values_default()
my_parameters$efficiencywithdrawal <- 0.5
my_parameters$`penalize-variation-injection` <- TRUE
my_parameters$`penalize-variation-withdrawal` <- TRUE

editClusterST(area = "areaname", 
              cluster_name = "clustername", 
              storage_parameters = my_parameters)

# edit time series
ratio_data <- matrix(0.7, 8760)

editClusterST(area = "areaname", 
              cluster_name = "clustername",
              cost_injection = ratio_data, 
              cost_withdrawal = ratio_data, 
              cost_level = ratio_data, 
              cost_variation_injection = ratio_data, 
              cost_variation_withdrawal = ratio_data)
              
# Edit optional constraints properties 
# make a list with names for the section and mandatory parameters

constraints_properties <- list(
  "withdrawal-1"= list(
    variable = "withdrawal",
    operator = "equal",
    hours = c("[1,3,5]", 
              "[120,121,122,123,124,125,126,127,128]")
  ),
  "netting-1"= list(
    variable = "netting",
    operator = "less",
    hours = c("[1, 168]")
  ))     
  
# make a list for TS with same names like previous properties
TS_values <- matrix(0.2, 8760)

constraints_ts <- list(
  "withdrawal-1"=TS_values,
  "netting-1"=TS_values)0

editClusterST(area = "areaname", 
              cluster_name = "clustername", 
              constraints_properties = constraints_properties,
              constraints_ts = constraints_ts)    

# study version >= "9.3" (new parameters)

my_parameters <- storage_values_default()
my_parameters$`allow-overflow` <- TRUE

# edit time series
ratio_data <- matrix(0.7, 8760, N)

editClusterST(area = "areaname", 
              cluster_name = "clustername",
              cost_injection = ratio_data)
                       
}
}
\seealso{
\code{\link[=createClusterST]{createClusterST()}}, \code{\link[=removeClusterST]{removeClusterST()}}
}
