% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_descriptions.R
\docType{data}
\name{data_lorenz}
\alias{data_lorenz}
\title{A subset of data from Lorenz & Koella (2011)}
\format{
An object of class \code{data.frame} with 256 rows and 8 columns.
}
\source{
Lorenz LM & Koella JC (2011) The microsporidian parasite
Vavraia culicis as a potential late life-acting control agent of malaria.
Evolutionary
Applications 4: 783-790
\href{https://doi.org/10.1111/j.1752-4571.2011.00199.x}{doi}

The full dataset is available at Dryad
\url{https://doi.org/10.5061/dryad.2s231}
}
\usage{
data_lorenz
}
\value{
A dataframe
\describe{
\item{Infectious.dose}{Number of spores larvae
were exposed to (spores/larva)}
\item{Food}{food treatment: '50' or '100'}
\item{Sex}{sex of mosquito: 'F' female}
\item{Spore.Count}{number of spores harboured by mosquito at time of death}
\item{t}{time of death to nearest half day}
\item{censored}{'1' censored, '0' died}
\item{d}{death indicator: '1' died during experiment, '0' right-censored}
\item{g}{infection treatment indicator: '0' uninfected, '1' infected}
}
}
\description{
Data on the longevity of 256 adult female mosquitoes and the number of
pathogen spores they harboured at the time of their death.
}
\details{
These are the Lorenz & Koella data analysed in Agnew (2019)
\href{https://doi.org/10.1101/530709}{doi}
}
\examples{
head(data_lorenz)
}
\keyword{datasets}
