% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/capa.R
\docType{methods}
\name{point_anomalies}
\alias{point_anomalies}
\alias{point_anomalies,capa.class-method}
\title{Point anomaly location and strength.}
\usage{
point_anomalies(object, ...)

\S4method{point_anomalies}{capa.class}(object, epoch = nrow(object@data))
}
\arguments{
\item{object}{An instance of an S4 class produced by \code{\link{capa}}.}

\item{...}{TODO}

\item{epoch}{Positive integer. CAPA methods are sequential and as such, can generate results up to, and including, any epoch within the data series. This can be controlled by the value
of \code{epoch} and is useful for examining how the inferred anomalies are modified as the data series grows. The default value for \code{epoch} is the length of the data series.}
}
\value{
A data frame.
}
\description{
Creates a data frame containing point anomaly locations and strengths as detected by \code{\link{capa}}.
 
Returns a data frame with columns containing the position, strength, and (for multivariate data) the variate number.
}
\seealso{
\code{\link{capa}}.
}
