% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{distributions}
\alias{distributions}
\alias{make_distribution}
\alias{make_exp_distr}
\alias{make_hnorm_distr}
\alias{make_lnorm_distr}
\alias{make_unif_distr}
\alias{make_vonmises_distr}
\alias{make_gamma_distr}
\title{Functions create statistical distributions}
\usage{
make_distribution(name, params, vcov = NULL, ...)

make_exp_distr(rate = 1)

make_hnorm_distr(sd = 1)

make_lnorm_distr(meanlog = 0, sdlog = 1)

make_unif_distr(min = -pi, max = pi)

make_vonmises_distr(kappa = 1, vcov = NULL)

make_gamma_distr(shape = 1, scale = 1, vcov = NULL)
}
\arguments{
\item{name}{\verb{[char(1)]} \cr Short name of distribution. See \code{available_distr()}
for all currently implemented distributions.}

\item{params}{\verb{[list]} \cr A named list with parameters of the distribution.}

\item{vcov}{\verb{[matrix]} \cr A matrix with variance and covariances.}

\item{...}{none implemented.}

\item{rate}{\verb{[double(1)>0]} \cr The rate of the exponential distribution.}

\item{sd}{\verb{[double(1)>0]} \cr The standard deviation of the half-normal distribution.}

\item{meanlog}{\verb{[double(1)>0]} \cr The standard deviation of the half-normal distribution.}

\item{sdlog}{\verb{[double(1)>0]} \cr The standard deviation of the half-normal distribution.}

\item{min}{\verb{[double(1)]} \cr The minimum of the uniform distribution.}

\item{max}{\verb{[double(1)]} \cr The minimum of the uniform distribution.}

\item{kappa}{\verb{[double(1)>=0]} \cr Concentration parameter of the von Mises distribution.}

\item{shape, scale}{\verb{[double(1)>=0]} \cr Shape and scale of the Gamma distribution}
}
\value{
A list of class \code{amt_distr} that contains the name (\code{name}) and parameters (\code{params}) of a distribution.
}
\description{
\code{make_distributions} creates a distribution suitable for using it with integrated step selection functions
}
