% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_tri}
\alias{process_tri}
\title{Process toxic release data}
\usage{
process_tri(
  path = NULL,
  year = 2018,
  variables = c(1, 13, 12, 14, 20, 34, 36, 47, 48, 49),
  extent = NULL,
  ...
)
}
\arguments{
\item{path}{character(1). Path to the directory with TRI CSV files}

\item{year}{integer(1). Single year to select.}

\item{variables}{integer. Column index of TRI data.}

\item{extent}{numeric(4) or SpatExtent giving the extent of the raster
if \code{NULL} (default), the entire raster is loaded}

\item{...}{Placeholders.}
}
\value{
a \code{SpatVector} object (points) in \code{year}
\code{year} is stored in a field named \code{"year"}.
}
\description{
This function imports and cleans raw toxic release data,
returning a single \code{SpatVector} (points) object for the selected \code{year}.
}
\note{
Visit \href{https://www.epa.gov/toxics-release-inventory-tri-program/tri-toolbox}{TRI Data and Tools}
to view the available years and variables.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
tri <- process_tri(
  path = "./data",
  year = 2020,
  variables = c(1, 13, 12, 14, 20, 34, 36, 47, 48, 49)
)
}
}
\references{
https://www.epa.gov/toxics-release-inventory-tri-program/tri-toolbox
}
\author{
Insang Song, Mariana Kassien
}
