% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_to_first_dose_increase.R
\name{time_to_first_dose_increase}
\alias{time_to_first_dose_increase}
\title{Plot the time taken for FIRST 6-Mercaptopurine (6MP) dose increase in cohort}
\usage{
time_to_first_dose_increase(input_files_path, escalation_factor)
}
\arguments{
\item{input_files_path}{Path to folder with MT csv files (in quotes)}

\item{escalation_factor}{Percentage of increase from first dose to be considered as an "increased" dose.}
}
\value{
Median time (in weeks) to first 6MP dose increase plot
}
\description{
Evaluate median time (in weeks) to first 6MP dose increase for the cohort using Kaplan-Meier cumulative incidence estimator using \link[survminer]{ggsurvplot} package
}
\examples{
cohort_path = paste0(system.file("extdata/processed_data/", package = "allMT"), "/")
time_to_first_dose_increase(input_files_path = cohort_path,
                escalation_factor = 10)


}
\seealso{
\code{\link[=assess_increased_doses]{assess_increased_doses()}}
}
