% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_anemia.R
\name{assess_anemia}
\alias{assess_anemia}
\title{Assess hematological toxicities: Anemia}
\usage{
assess_anemia(input_files_path, hb_range, duration_hb = NA)
}
\arguments{
\item{input_files_path}{path to a file or a folder with MT csv files (in quotes).}

\item{hb_range}{Hemoglobin (HB) value range of c(Anemic HB threshold, recovered HB threshold). NOTE: Ensure that units are the same as unit of HB in the input data.}

\item{duration_hb}{numeric duration (in weeks) that is used to categorize event as "long duration anemia" (optional)}
}
\value{
Returns a list with (1) the anemia information for each patient as listed below,
(2) analysis summary as dataframe (3) analysis summary as HTML table.
\enumerate{
\item{Pat ID}
\item{Number of particular toxicity episodes}
\item{Duration of particular toxicity (in weeks)}
\item{Number of long duration toxicity episodes}
\item{Duration of long duration toxicity (in weeks)}
}
}
\description{
Evaluate number of anemia episodes and their duration for a given patient or cohort
}
\note{
\enumerate{
\item{If the function is used for cohort analysis then values are represented as median and interquartile range (IQR) (25\%-75\%). The median and IQR is rounded off to upper integer value if decimal value is greater or equal to 0.5, else to lower integer value. Example 1.4->1 and 3.75->4}
\item{Long duration toxicity is only analyzed if "duration_hb" is included in provided arguments}
\item{User may save the result as a list, if required, to analyze each patient seperatly please use 1st element of list}
}
}
\examples{
pat_data = system.file("extdata/processed_data/", "UPN_915.csv", package = "allMT")
assess_anemia(input_files_path = pat_data,
                      hb_range = c(7, 8), duration_hb = 3)

\donttest{

cohort_path = paste0(system.file("extdata/processed_data/", package = "allMT"), "/")
assess_anemia(input_files_path = cohort_path,
                      hb_range = c(7, 8), duration_hb = 3)

result <- assess_anemia(input_files_path = pat_data,
                      hb_range = c(7, 8), duration_hb = 3)
print(result[[1]])
print(result[[2]])
print(result[[3]])
}


}
\seealso{
\code{\link[=assess_neutropenia]{assess_neutropenia()}}, \code{\link[=assess_thrombocytopenia]{assess_thrombocytopenia()}}
}
