% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyword_network.R
\name{keyword_network}
\alias{keyword_network}
\title{Flexiable visualization of network (alternative to 'keyword_vis')}
\usage{
keyword_network(
  tibble_graph,
  group_no = NULL,
  facet = TRUE,
  max_nodes = 10,
  alpha = 0.7
)
}
\arguments{
\item{tibble_graph}{A \code{tbl_graph} output by \code{\link[akc]{keyword_group}}.}

\item{group_no}{If one wants to visualize a specific group, gives the group number.
Default uses \code{NULL},which returns all the groups.}

\item{facet}{Whether the figure should use facet or not.}

\item{max_nodes}{The maximum number of nodes displayed in each group.}

\item{alpha}{The transparency of label. Must lie between 0 and 1. Default uses 0.7.}
}
\value{
An object yielded by \code{\link[ggraph]{ggraph}}
}
\description{
Providing flexible visualization of \code{\link[akc]{keyword_vis}}. The
group size would be showed, and user could extract specific group to visualize.
}
\details{
If the \code{group_no} is not specified, when \code{facet == TRUE},
the function returns a faceted figure with limited number of nodes
(adjuseted by \code{max_nodes} parameter). The "N=" shows the total size of the group.

When \code{facet == FALSE},all the nodes would be displayed in one
network.Colors are used to specify the groups, the size of nodes is proportional to the keyword frequency,
while the alpha of edges is proportional to the co-occurrence relationship between keywords.

If the \code{group_no} is specified, returns the network visualization of the group.
If you want to display all the nodes, set \code{max_nodes} to \code{Inf}.
}
\examples{

 library(akc)
\donttest{
 bibli_data_table \%>\%
   keyword_clean(id = "id",keyword = "keyword") \%>\%
   keyword_group(id = "id",keyword = "keyword") \%>\%
   keyword_network()

# use color with `scale_fill_`
 bibli_data_table \%>\%
   keyword_clean(id = "id",keyword = "keyword") \%>\%
   keyword_group(id = "id",keyword = "keyword") \%>\%
   keyword_network() + ggplot2::scale_fill_viridis_d()

 # without facet
 bibli_data_table \%>\%
   keyword_clean(id = "id",keyword = "keyword") \%>\%
   keyword_group(id = "id",keyword = "keyword") \%>\%
   keyword_network(facet = FALSE)

# get Group 5
 bibli_data_table \%>\%
   keyword_clean(id = "id",keyword = "keyword") \%>\%
   keyword_group(id = "id",keyword = "keyword") \%>\%
   keyword_network(group_no = 5)
}
}
\seealso{
\code{\link[ggraph]{ggraph}},\code{\link[akc]{keyword_vis}}
}
